package com.ejie.p06b.manager;

import java.util.ArrayList;

import com.ejie.p06b.dao.P06B62T00DAO;
import com.ejie.p06b.datatype.logic.P06BInformeDEC;
import com.ejie.p06b.datatype.logic.P06BInformeOtroDEC;
import com.ejie.p06b.datatype.logic.P06BInformeOtroDECDet;
import com.ejie.p06b.datatype.logic.pagination.P06BCorredorPagination;
import com.ejie.p06b.datatype.logic.pagination.P06BDECPagination;
import com.ejie.p06b.datatype.model.P06B62T00Datatype;
import com.ejie.p06b.exception.P06BException;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BErrores;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BPage;
import com.ejie.p06b.util.P06BPaginator;

/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * 
 * Manager para la gestin del PRD (Pantallas mdulo PRDes)
 * 
 * Fecha de creacin: (25/05/07)
 */
public class P06BPRDsManager {
	
	static private P06BPRDsManager instance = null;

	public static P06BPRDsManager getInstance() {
	     if (instance == null) {
	          synchronized (P06BPRDsManager.class) {
	          		if (instance == null) {
	                     instance = new P06BPRDsManager();
	                }
	          }
	     }
	     return instance;
	}
	
	/**
    * Inserta un registro en la BD -> De momento en la P06B62T00
    * 
    * @param obj 
    * 			Elemento que deseamos insertar
    * @return String
    * 			El Expediente creado
    * @throws P06BException
    */
	public void insertPRD(P06B62T00Datatype obj) throws P06BException{
		try {
			P06B62T00DAO.getInstance().insert(obj);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BPRDsManager - insertPRD: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene un registro P06B62T00Datatype a partir de la clave primaria -> N Exp.
    * 
    * @param numExp 
    * 			Clave primaria de la tabla en BD
    * @return P06B62T00Datatype
    * 			ValueObject obtenido
    * @throws P06BException
    */
	public P06B62T00Datatype selectPRD(int ejercicio) throws P06BException{
		try {
			return P06B62T00DAO.getInstance().select(ejercicio);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BPRDsManager - selectPRD: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Inserta los PRDs asociados al expediente
    * 
    * @param listaPRDs 
    * 			Lista de PRDs a insertar
    * @param exp 
    * 			Expediente al que se asocia cada PRD
    * @throws P06BException
    */
	public void insertPRDs(ArrayList listaPRDs) throws P06BException{
		try {
			if(listaPRDs.isEmpty())
				return;
			for(int i=0;i<listaPRDs.size();i++){
				//Recorro los PRDs a insertar
				P06B62T00Datatype prd = (P06B62T00Datatype)listaPRDs.get(i);
				P06B62T00DAO.getInstance().insert(prd);
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BPRDsManager - insertPRDs: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	
	/**
    * Obtiene la lista de PRDs vinculados al expediente
    * 
    * @param numExp 
    * 			Define el exp cuyos PRDs deseo obtener
    * @return ArrayList
    * @throws P06BException
    */
	public ArrayList selectPRDs() throws P06BException{
		try {
			return P06B62T00DAO.getInstance().selectAll();
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BPRDsManager - selectPRDs: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Primero eliminamos todos los PRDs asociados al expediente
    * Segundo los insertamos otra vez los que queden
    * 
    * @param listaPRDs 
    * 			Lista de PRDs directos a insertar
    * @param exp 
    * 			Expediente al que se asocia cada PRD directo
    * @throws P06BException
    */
	public void deleteAndInsertListaPRDs(ArrayList listaPRDs) throws P06BException{
		try {
			P06B62T00DAO.getInstance().deleteAll();
			for(int i=0;i<listaPRDs.size();i++){
				//Recorro los PRDs a insertar
				P06B62T00Datatype prd = (P06B62T00Datatype)listaPRDs.get(i);
				P06B62T00DAO.getInstance().insert(prd);
			}
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BPRDsManager - deleteAndInsertListaPRDs: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
		
	/**
    * Obtiene el numero de objetos del expediente y tipo indicados
    * 
    * @param numExp 
    * 			Define el exp cuyo objeto deseo obtener
    * @param tipo 
    * 			Define el tipo (PRD directo, indirecto o auxiliar externo) cuyo objeto deseo obtener
    * @return int: numero de objetos que cumple los parametros de entrada
    * @throws P06BException
    */
	public int selectNumPRDs() throws P06BException{
		try {
			return P06B62T00DAO.getInstance().selectNumObj();
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BPRDsManager - selectNumPRDs: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}	

}
